﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Business.Db" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-02</title>
		<script runat="server">
	
	//Nazwa cechy typu liczba całkowita dla definicji elementu z numerem wiersza,
	//w którym ma zostać umieszczona wartość danego elementu.
	//Jeżeli wartość "" to cecha nie jest odczytywana.
	static string nazwaCechy = "Pozycja GUS Z02";

    static string traceName = "";
		    	
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            if (data.Month<7)
				rok --;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {				
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        [Priority(2)]
        public FromTo Okres {
			get { return FromTo.Year(rok); }
        }
	}

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
        //static bool debug = false;
        bool debug = false;
        [Priority(1)]
        [Caption("Liczby bez zaokrąglenia")]
        public bool Debug {
            get { return debug; }
            set {
                debug = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
        //przez listę a nie dla wszystkich
        //static bool wglisty = false;	
        bool wgListy = false;
        [Priority(2)]
        [Caption("Pracownicy wg listy")]
        public bool WgListy {
            get { return wgListy; }
            set {
                wgListy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        string zapis = "";
        [Priority(3)]
        [Caption("Zapis obliczeń")]
        public string Zapis {
            get { return zapis; }
            set {
                zapis = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
		    		              
    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set {
            srpars = value;
            traceName = srpars.Zapis;
        }
    }		
		            
    Dictionary<object, List<Pracownik>> dict = new Dictionary<object, List<Pracownik>>();
    static Log trace;
    string title;
	Date ostatni;
	FromTo rok;
	
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["ROK"] = pars.Rok.ToString();
        title = ReportHeader.Title;

        trace = null;
        if (traceName != "")
            trace = new Log(traceName, true);
        
		TestCechy();
		
        rok = pars.Okres;
        ostatni = rok.To;
        YearMonth ym = new YearMonth(rok.From);
        for (int i=0; i<12; i++) {
			dni[i] = ym.Days;
			ym += 1;
		}

        KadryModule kadry = KadryModule.GetInstance(dc);
        IEnumerable pracownicy;
        if (srpars.WgListy) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
        }
        else {
            Soneta.Business.View view = kadry.Pracownicy.CreateView();
            view.ForceAllRows();
            pracownicy = view;
        }

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Okres.To;
            foreach (Pracownik pracownik in pracownicy) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.ZUS == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(string.Empty, list = new List<Pracownik>());
            foreach (Pracownik pracownik in pracownicy)
                list.Add(pracownik);
        }

        DataRepeater1.DataSource = dict.Keys;
    }

	void OnBeforeRow(Object sender, EventArgs args) {
        report = ReportHeader;

        object of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            report.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            report.Title = title.Replace("%ODDZIAL%", "");

        string pkdFirmy = CoreModule.GetInstance(dc).Config.Firma.Pieczątka.PKD;
        if (pkdFirmy.Length == 0)
            pkdFirmy = "&nbsp;";
        pkd.EditValue = pkdFirmy;
        
        int osoby1231 = 0;
        foreach (Pracownik pracownik in dict[of]) {
            Trace("===============================================================================");
            Trace(pracownik);
            Trace("-- Zatrudnienie w dniu {0} --", ostatni);
            KalkulatorPracy kalk = new KalkulatorPracy(pracownik);
			if (Zatrudniony(pracownik, kalk))
				osoby1231++;

            Trace("-- Przeciętne zatrudnienie ----------------------------------------------------");
			foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(EfektywnyOkres(pracownik, rok)))
				AddZatrudnienie(ph, kalk);

            Trace("-- Składniki wynagrodzenia ----------------------------------------------------");
            AddElementy(pracownik);			
        }

        osobyOgółem.EditValue = osoby1231;
        
        osobyPełn.EditValue = Przeciętnie(osobyP);
        osobyNiep.EditValue = Przeciętnie(osobyNP);
        etatyNiep.EditValue = Przeciętnie(etatyNP);
        osobyUczn.EditValue = Przeciętnie(osobyU);
        etatyUczn.EditValue = Przeciętnie(etatyU);

        czasPełn.EditValue = Czas(togółem[0]);
        czasNiep.EditValue = Czas(togółem[1]);
        czasUczn.EditValue = Czas(togółem[2]);

        normaPełn.EditValue = Czas(tnorma[0]);
        normaNiep.EditValue = Czas(tnorma[1]);
        normaUczn.EditValue = Czas(tnorma[2]);
        
        nadliczPełn.EditValue = Czas(tnadlicz[0]);
        nadliczNiep.EditValue = Czas(tnadlicz[1]);
        nadliczUczn.EditValue = Czas(tnadlicz[2]);
        
        płatnePełn.EditValue = Czas(tpłatne[0]);
        płatneNiep.EditValue = Czas(tpłatne[1]);
        płatneUczn.EditValue = Czas(tpłatne[2]);

        prac01.EditValue = Tys(kwotyPrac[01]);
        uczn01.EditValue = Tys(kwotyUczn[01]);
        
        prac02.EditValue = Tys(kwotyPrac[02]);
        uczn02.EditValue = Tys(kwotyUczn[02]);
        
        prac03.EditValue = Tys(kwotyPrac[03]);
        prac04.EditValue = Tys(kwotyPrac[04]);
        prac05.EditValue = Tys(kwotyPrac[05]);
        prac06.EditValue = Tys(kwotyPrac[06]);
        prac07.EditValue = Tys(kwotyPrac[07]);
        prac08.EditValue = Tys(kwotyPrac[08]);
        prac09.EditValue = Tys(kwotyPrac[09]);
        prac10.EditValue = Tys(kwotyPrac[10]);
        prac11.EditValue = Tys(kwotyPrac[11]);
        prac12.EditValue = Tys(kwotyPrac[12]);
        prac13.EditValue = Tys(kwotyPrac[13]);
        prac14.EditValue = Tys(kwotyPrac[14]);
        prac15.EditValue = Tys(kwotyPrac[15]);
        prac16.EditValue = Tys(kwotyPrac[16]);
        prac17.EditValue = Tys(kwotyPrac[17]);
        prac18.EditValue = Tys(kwotyPrac[18]);
        
        prac19.EditValue = Tys(kwotyPrac[19]);
        uczn19.EditValue = Tys(kwotyUczn[19]);
        
        prac20.EditValue = Tys(kwotyPrac[20]);
        
        prac21.EditValue = Tys(kwotyPrac[21]);
        prac22.EditValue = Tys(kwotyPrac[22]);
        prac23.EditValue = Tys(kwotyPrac[23]);
        prac24.EditValue = Tys(kwotyPrac[24]);
                
        prac25.EditValue = Tys(kwotyPrac[25]);
        uczn25.EditValue = Tys(kwotyUczn[14] + kwotyUczn[15] + kwotyUczn[16] + kwotyUczn[17] + kwotyUczn[18] 
            + kwotyUczn[20]
            + kwotyUczn[22] + kwotyUczn[23] + kwotyUczn[24]);
        
        prac26.EditValue = Tys(kwotyPrac[26]);
        uczn26.EditValue = Tys(kwotyUczn[26]);
        
        prac27.EditValue = Tys(kwotyPrac[27]);
        prac28.EditValue = Tys(kwotyPrac[28]);
        prac29.EditValue = Tys(kwotyPrac[29]);
    }

	void TestCechy() {
		if (nazwaCechy!="") {
			FeatureDefs fd = BusinessModule.GetInstance(dc).FeatureDefs;
			bool update = fd.ByName[typeof(DefElementow).Name, nazwaCechy]!=null;
			if (!update)
				nazwaCechy = "";
		}
	}
	
    decimal[] kwotyPrac = new decimal[30];
    decimal[] kwotyUczn = new decimal[30];
    
    Time[] togółem = new Time[3];
    Time[] tnorma = new Time[3];
    Time[] tnadlicz = new Time[3];
    Time[] tpłatne = new Time[3];

            void AddElementy(Pracownik pracownik) {
                SubTable st = PlaceModule.GetInstance(pracownik).WypElementy.WgOkresuListy[pracownik];
                FromTo okres = EfektywnyOkres(pracownik, rok);
                st = new SubTable(st, okres);

                foreach (WypElement element in st) {
                    try {
                        Trace(" * {0} ({1}), wykazuj na deklaracjach: {2}", element.Nazwa, element.Okres, element.Definicja.GUS.WykazujNaDeklaracjach);
                        if (element.Definicja.GUS.WykazujNaDeklaracjach) {
                            bool uczeń;
                            PracHistoria ph = element.PracHistoria;
                            if (GetZatrudniony(ph, out uczeń)) {
                                AddElementCzas(element, ph, uczeń);
                                AddElementKwota(element, ph, uczeń);
                            }
                        }
                    }
                    catch { Msg(); }
                }
            }

	void AddElementKwota(WypElement element, PracHistoria ph, bool uczeń) {
		decimal zus = element.Podatki.FirmaZUS;
		decimal fp = element.Podatki.FP.Skladka + element.Podatki.FGSP.Skladka + element.Podatki.FEP.Skladka;
		
		decimal[] kwoty = uczeń ? kwotyUczn : kwotyPrac;

        Trace("    Narzuty: {0}", zus + fp);
        
        kwoty[19/*20*/] += zus + fp;
        kwoty[01] += zus + fp;
        
		int pozycja = 0;
		decimal dopłata = 0;
		if (nazwaCechy!="")
			pozycja = element.Definicja.Features.GetInt(nazwaCechy);
		if (pozycja==0)
			pozycja = PozycjaElementu(element, ph, ref dopłata);

        Trace("    Pozycja: {0}", pozycja);
			
		if (pozycja>0 && pozycja<99) {
			decimal wartość = element.Wartosc;
			Dodaj(kwoty, pozycja, wartość - dopłata);
			Dodaj(kwoty, 07, dopłata);
            Trace("    Wartość: {0}, w tym dopłata: {1}", wartość, dopłata);
        }
	}
	
	void Dodaj(decimal[] kwoty, int pozycja, decimal wartość) {
		if (wartość!=0m) {
            
			kwoty[pozycja] += wartość;
            
			if (03<=pozycja && pozycja<=13) {
				kwoty[01] += wartość;
				kwoty[02] += wartość;
			}
            else if (14 <= pozycja && pozycja <= 20)
                kwoty[01] += wartość;
            else if (22 <= pozycja && pozycja <= 25)
                kwoty[01] += wartość;
            else if (27 <= pozycja && pozycja <= 29)
				kwoty[26] += wartość;
		}
	}

	int PozycjaElementu(WypElement element, PracHistoria ph, ref decimal dopłata) {
		switch (element.Definicja.GUS.Kategoria) {
			case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
                return 27;// 26;
			case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
                return 14;// 15;
			case KategoriaWynagrodzeniaGUS.Honorarium:
                if (!ZatrudnionyFirma(element))
                    return 0;
                return 16;// 17;
			//case KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne:
			//	throw new Exception("KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne");
            case KategoriaWynagrodzeniaGUS.WynagrodzenieUmowa:
                if (!ZatrudnionyFirma(element))
                    return 0;
                return 15;// 16;
            case KategoriaWynagrodzeniaGUS.WynagrodzenieNadliczbowe:
                return 07;
            case KategoriaWynagrodzeniaGUS.WynagrodzenieOsobowe:
                return 03;
            case KategoriaWynagrodzeniaGUS.WynagrodzeniePracaNakładcza:
                return 13;// 14;
			case KategoriaWynagrodzeniaGUS.WgDefinicjiElementu:
				if (element.Definicja.Info.Opodatkowany && !element.ZasiłekZus && !element.ZasiłekBudżet)
					if (element.Wyplata.Typ==TypWyplaty.Umowa) {
                        if (!ZatrudnionyFirma(element))
                            return 0;
						if (Honorarium(element))
							return 16;//17;
						else if (UmowaZlecenie(element))
                            return 15;// 16;
					}
					else {
						switch (element.RodzajZrodla) {
							case RodzajŹródłaWypłaty.NadgodzinyI:
							case RodzajŹródłaWypłaty.NadgodzinyII:
							case RodzajŹródłaWypłaty.NadgodzinyŚw:
								return 07;
							case RodzajŹródłaWypłaty.Etat:
								foreach (WypSkladnik s in element.Skladniki)
									switch (s.Rodzaj) {
										case RodzajSkładnikaWypłaty.OdchyłkaPlus:
										case RodzajSkładnikaWypłaty.OdchyłkaMinus:
											dopłata += s.Wartosc; 
											break;
										}
								
								if (dopłata<0m)
									dopłata = 0m;
								return 03;

                            case RodzajŹródłaWypłaty.Odchyłki:
                                dopłata += element.Wartosc; 
								if (dopłata<0m)
									dopłata = 0m;
								return 03;
                                
							case RodzajŹródłaWypłaty.Nieobecność:
								Nieobecnosc n = ((WypElementNieobecność)element).Nieobecność;
								if (n!=null)
									switch (n.Definicja.Przyczyna) {
										//case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
										//	return 10;
										case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
										case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
											return 8;
									}
                                return 10;// 11;
							case RodzajŹródłaWypłaty.Kurs:
                                return 17;// 18;
							case RodzajŹródłaWypłaty.Świadczenie:
                                return 28;// 27;
							case RodzajŹródłaWypłaty.Nagroda:
								return 06;
							default:
                                return 13;// 14;
						}
					}
				break;
			default:
				throw new Exception("Nieoczekiwana wartość pola element.Definicja.GUS.Kategoria: " + element.Definicja.GUS.Kategoria);						
		}
		
		return 0;
	}

    bool ZatrudnionyFirma(WypElement element) {        
        TytulUbezpieczenia tyub = element.Podatki.TyUb;
        return tyub != TytulUbezpieczenia.Empty && tyub.Podmiot == 110;
    }

	bool Honorarium(WypElement element) {
		PozycjaPIT pit = element.Definicja.Deklaracje.PozycjaPIT;
		return pit!=null && pit.PIT8B==70;
	}
	
	bool UmowaZlecenie(WypElement element) {
		switch (element.Definicja.Deklaracje.Umowa) {
			case TypUmowyCywilnoPrawnej.UmowaODzieło:
			case TypUmowyCywilnoPrawnej.UmowaZlecenia:
				return true;
		}
		return false;
	}

	void AddElementCzas(WypElement element, PracHistoria ph, bool uczeń) {
		Time norma = Time.Zero;
		Time plus = Time.Zero;
		Time minus = Time.Zero;
		Time nieob = Time.Zero;
		Time płatne = Time.Zero;
        bool pokaż = false;
		switch (element.RodzajZrodla) {
			case RodzajŹródłaWypłaty.Etat:
                pokaż = true;
				foreach (WypSkladnik s in element.Skladniki)
					switch (s.Rodzaj) {
						case RodzajSkładnikaWypłaty.Główny:
							norma += s.Czas; break;
						case RodzajSkładnikaWypłaty.OdchyłkaPlus:
							plus += s.Czas; break;
						case RodzajSkładnikaWypłaty.OdchyłkaMinus:
							minus -= s.Czas; break;						
						case RodzajSkładnikaWypłaty.PomniejszenieProp:
						case RodzajSkładnikaWypłaty.Pomniejszenie130:
						case RodzajSkładnikaWypłaty.PomniejszenieZaDzień:
						case RodzajSkładnikaWypłaty.PomniejszenieStorno:
                        case RodzajSkładnikaWypłaty.PomniejszeniePropZero:
							nieob -= s.Czas; break;						
						case RodzajSkładnikaWypłaty.Korekta:
						case RodzajSkładnikaWypłaty.OdchyłkaAkordMinus:
							break;
						default:
							throw new Exception("Nieoczekiwana wartość pola Rodzaj (składnika): " + s.Rodzaj);
					}
				break;
				
			case RodzajŹródłaWypłaty.Nieobecność:
				if (!element.ZasiłekZus && !element.ZasiłekBudżet) {
                    pokaż = true;
                    płatne = element.Czas;
					if (płatne==Time.Zero) {
						KalkulatorPlanu kp = new KalkulatorPlanu(element.Pracownik);
						płatne = kp.Norma(element.Okres).Czas;
					}
				}
				break;

            case RodzajŹródłaWypłaty.Odchyłki:
                if (element.Czas > Time.Zero)
                    plus += element.Czas;
                else
                    minus -= element.Czas;
                break;
			
			default:
				return;
		}

        if (pokaż)
            Trace("    Norma :{0}, plus :{1}, minus: {2}, nieobecności: {3}, nieobecności płatne: {4}",
                norma, plus, minus, nieob, płatne);
        
		int idx = uczeń ? 2 : ph.Etat.Zaszeregowanie.Wymiar!=Fraction.One ? 1 : 0;
		Time odchyłka = plus - minus;
		togółem[idx] += norma + odchyłka + płatne - nieob;
		tnorma[idx] += norma - nieob;
		tpłatne[idx] += płatne;				
		if (odchyłka>Time.Zero)
			tnadlicz[idx] += odchyłka;
		else
			tnorma[idx] += odchyłka;
	}
    	
	int[] dni = new int[12];
    decimal[] osobyP = new decimal[12];
    decimal[] osobyNP = new decimal[12];
    decimal[] osobyU = new decimal[12];
    decimal[] etatyNP = new decimal[12];
    decimal[] etatyU = new decimal[12];

    bool WykluczPracownika(KalkulatorPracy kalk, FromTo zatrudniony, bool test) {
        Periods wych3m = Periods.Empty;
        Periods bezp3m = Periods.Empty;
        Periods rehab = Periods.Empty;

		foreach (INieobecnosc nieobecność in kalk.Nieobecnosci(zatrudniony, true))
			switch (nieobecność.Definicja.Przyczyna) {
				case PrzyczynaNieobecnosci.UrlopWychowawczy:
				case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
                    wych3m += nieobecność.Okres;
                    break;
				case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                    rehab += nieobecność.Okres;
                    break;
				case PrzyczynaNieobecnosci.UrlopBezpłatny:
                    bezp3m += nieobecność.Okres;
					break;
			}

        // wychowawczy powyżej 3 miesięcy w jednej całości
        wych3m = wych3m.ToFlat();
		foreach (FromTo okres in wych3m)
            if (okres.Days > 90 && (!test || okres.Contains(ostatni)))
                return true;

        // bezpłatny powyżej 3 miesięcy
        int bezp = 0;
        bezp3m = bezp3m.ToFlat();
		foreach (FromTo okres in bezp3m)
            bezp += okres.Days;
        if (bezp > 90 && (!test || rehab.Contains(ostatni)))
            return true;

        // rehabilitacyjny w dowolnej wysokości
        if (rehab != Periods.Empty && (!test || rehab.Contains(ostatni)))
            return true;

        return false;
    }

	void AddZatrudnienie(PracHistoria ph, KalkulatorPracy kalk) {
		bool uczeń;
        Trace(" * Aktualizacja: {0}", ph.Aktualnosc);
		if (GetZatrudniony(ph, out uczeń)) {			
			FromTo zatrudniony = EfektywnyOkres(ph) * rok;
            if (WykluczPracownika(kalk, zatrudniony, false))
                return;
            Trace("    Ograniczony okres zatrudnienia: {0}, wymiar etatu: {1}, uczeń: {2}", zatrudniony, ph.Etat.Zaszeregowanie.Wymiar, uczeń);
            Periods okresy = Periods.New(zatrudniony);
			foreach (INieobecnosc nieobecność in kalk.Nieobecnosci(zatrudniony, true))
				switch (nieobecność.Definicja.Przyczyna) {
					case PrzyczynaNieobecnosci.UrlopWychowawczy:
					case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
					case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
					case PrzyczynaNieobecnosci.UrlopBezpłatny:
					    okresy -= nieobecność.Okres;
                        Trace("    Nieobecność: {0}, {1}", nieobecność.Definicja.Przyczyna, nieobecność.Okres);
						break;
				}
            
            if (zatrudniony != FromTo.Empty) {
                SubTable st = PlaceModule.GetInstance(ph).WypElementy.WgDaty[ph.Pracownik];
                st = new SubTable(st, zatrudniony);
                foreach (WypElement element in st) {
                    try {
                        if (element.Definicja.Nazwa.Contains("Zas. chorobowy") ||
                            element.Definicja.Nazwa.Contains("Zas.chorob.") ||
                            element.Definicja.Nazwa.Contains("Zas.chorobowy") ||
                            element.Definicja.Nazwa.Contains("Zas.macierzyński") ||
                            element.Definicja.Nazwa.Contains("Zas.opiekuńczy")) {
                            WypElementNieobecność wen = (WypElementNieobecność)element;
					        okresy -= wen.Nieobecność.Okres * wen.Okres;
                        }
                    }
                    catch { Msg(); }
                }
            }
            
            Trace("    Okresy wliczane (po uwzgl. nieobecności): {0}", okresy);
            
            okresy = okresy.BreakByMonth();

			foreach (FromTo okres in okresy) {
				int m = okres.From.Month - 1;
				decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
				if (uczeń) {
					osobyU[m] += okres.Days;
					etatyU[m] += okres.Days * w;
				}
				else if (w!=1m) {
					osobyNP[m] += okres.Days;
					etatyNP[m] += okres.Days * w;
				}
				else
					osobyP[m] += okres.Days;
			}
		}
	}
    
    bool GetZatrudniony(PracHistoria ph, out bool uczeń) {
		uczeń = false;
		switch (ph.Etat.RodzajZatrudnienia) {
			case RodzajZatrudnienia.NieDotyczy:
			case RodzajZatrudnienia.CzłonekRSP:
			case RodzajZatrudnienia.CzłonekSKR:
			case RodzajZatrudnienia.Student:
			case RodzajZatrudnienia.Absolwent:
            case RodzajZatrudnienia.WięzieńLubAresztowany:
                Trace("    {0}, wliczany", ph.Etat.RodzajZatrudnienia);
				return true;
						
			case RodzajZatrudnienia.Uczeń1Klasy:
			case RodzajZatrudnienia.Uczeń2Klasy:
			case RodzajZatrudnienia.Uczeń3Klasy:
			case RodzajZatrudnienia.MłodocianyPrzyuczany:
                Trace("    {0}, uczeń, wliczany", ph.Etat.RodzajZatrudnienia);
				uczeń = true;
				return true;

			case RodzajZatrudnienia.Właściciel:
			case RodzajZatrudnienia.OsobaWspółpracująca:
			case RodzajZatrudnienia.Chałupnik:
			case RodzajZatrudnienia.PracownikZaGranicą:
            case RodzajZatrudnienia.PracownikTymczasowy:
            case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
            case RodzajZatrudnienia.StanSpoczynku:
            case RodzajZatrudnienia.UposażenieRodzinne:
                //Agent
                Trace("    {0}, niewliczany", ph.Etat.RodzajZatrudnienia);
				return false;
			
			default:
				throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
		}
    }
    
    bool Zatrudniony(Pracownik pracownik, KalkulatorPracy kalk) {
		PracHistoria ph = pracownik[ostatni];
        FromTo zatrudniony = EfektywnyOkres(pracownik, ph.Etat.EfektywnyOkres);
        bool test = zatrudniony.Contains(ostatni);            
        if (WykluczPracownika(kalk, zatrudniony * rok, true))
            return false;

        Trace("  Zatrudniony: {0}, rodzaj zatrudnienia: {1}",
            //ph.GUS.GlowneMiejscePracy,
            test,
            ph.Etat.RodzajZatrudnienia);

		if (ph.GUS.GlowneMiejscePracy && test)
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				case RodzajZatrudnienia.Chałupnik:
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                case RodzajZatrudnienia.WięzieńLubAresztowany:
                    //Agent
                    Trace("  Wliczany");
					return true;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
                case RodzajZatrudnienia.StanSpoczynku:
                case RodzajZatrudnienia.UposażenieRodzinne:
                case RodzajZatrudnienia.PracownikTymczasowy:
                    break;
				
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}

        Trace("  Niewliczany");
        
        return false;
    }
            
    public decimal Przeciętnie(decimal[] lista) {
		decimal result = 0m;
		for (int i=0; i<12; i++)
			result += lista[i] / dni[i];
		result /= 12;
		return srpars.Debug ? Soneta.Tools.Math.Round(result, 2) : Soneta.Tools.Math.Round(result, 1);
    }

    public decimal Tys(decimal value) {
		if (srpars.Debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (srpars.Debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }

    static FromTo EfektywnyOkres(Pracownik p, FromTo okres) {
        foreach (PracHistoria ph in p.Historia.GetIntersectedRows(new FromTo(okres.From, Date.MaxValue)))
            if (ph.Etat.DataPrzejeciaPracownika != Date.Empty) {
                Date dt = okres.To != Date.Empty ? okres.To : Date.MaxValue;
                if (ph.Etat.DataPrzejeciaPracownika <= dt)
                    okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, dt);
                break;
            }
        return okres;
    }

    static FromTo EfektywnyOkres(PracHistoria ph) {
        FromTo okres = ph.Etat.EfektywnyOkres;
        if (ph.Etat.DataPrzejeciaPracownika != Date.Empty)
            okres *= new FromTo(ph.Etat.DataPrzejeciaPracownika, Date.MaxValue);
        return okres;
    }
    
    static void Trace(object value) {
        if (trace != null)
            trace.WriteLine(value == null ? "(null)" : value.ToString());
    }

    static void Trace(string format, params object[] values) {
        if (trace != null)
            trace.WriteLine(string.Format(format, values));
    }		        
		    	
    public static ReportHeader report;

    public static void Msg() {
        string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
        if (report != null && !report.Title.Contains(msg))
            report.Title += "|" + msg;
    }
            	    
		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" onbeforerow="OnBeforeRow">
            <ea:PageBreak ID="PageBreak6" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
            <eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie dla GUS Z-02|</strong>Rok: <strong>%ROK%|%ODDZIAL%" runat="server"></eb:reportheader>
			<P><STRONG>Dział 1. PODSTAWOWE DANE O JEDNOSTCE BADANEJ</STRONG></P>
			<P>
				<TABLE id="Table1" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>

						<TD width="80%">1. Symbol rodzaju podstawowej działalności według <STRONG>PKD 2007</STRONG>
							<BR>
						</TD>
						<TD align="right"><ea:datalabel id="pkd" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="80%"><STRONG>2. Proszę podać liczbę pracujących w osobach - stan w dniu 31 
								XII 2016 r.</STRONG>
							<BR>
							<EM>za pracujących uważa się osoby wykonujące pracę przynoszącą im zarobek (w formie wynagrodzenia za pracę) lub dochód, bez względu na miejsce i czas trwania pracy</EM>
						</TD>
						<TD align="right"><ea:datalabel id="osobyOgółem" runat="server"></ea:datalabel></TD>
					</TR>
					</TABLE>
			</P>
			<P><STRONG>Dział 2. ZATRUDNIENIE</STRONG> <EM>(w osobach, z jednym znakiem po przecinku)</EM></P>
			<P>
				<TABLE id="Table2" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD width="80%" colSpan="2"><STRONG>1. Proszę podać przeciętną liczbę osób 
								pełnozatrudnionych</STRONG></TD>
						<TD align="right"><ea:datalabel id="osobyPełn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="45%"><STRONG>2. Proszę podać przeciętną liczbę osób niepełnozatrudnionych</STRONG></TD>
						<TD>2.1 bez przeliczenia na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="osobyNiep" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>2.2 w przeliczeniu na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="etatyNiep" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD><STRONG>3. Proszę podać przeciętną liczbę osób (uczniów) zatrudnionych na podstawie 
								umowy o pracę w celu przygotowania zawodowego</STRONG></TD>
						<TD>3.1 bez przeliczenia na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="osobyUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>3.2 w przeliczeniu na pełne etaty</TD>
						<TD align="right"><ea:datalabel id="etatyUczn" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<P><STRONG>Dział 3. CZAS PRACY</STRONG> <EM>(w tys. godzin, z jednym znakiem po 
					przecinku)</EM></P>
			<P>
				<TABLE id="Table3" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="25%">Wyszczególnienie</TD>
						<TD align="center" width="25%">Pełnozatrudnieni</TD>
						<TD align="center" width="25%">Niepełnozatrudnieni</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
						<TD align="center"><FONT size="2">3</FONT></TD>
					</TR>
					<TR>
						<TD><STRONG>Ogółem</STRONG> - czas opłacony (wiersze 2 do 4)</TD>
						<TD align="right"><ea:datalabel id="czasPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="czasNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="czasUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Czas przepracowany w godzinach normalnych</TD>
						<TD align="right"><ea:datalabel id="normaPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="normaNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="normaUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Czas przepracowany w godzinach nadliczbowych</TD>
						<TD align="right"><ea:datalabel id="nadliczPełn" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nadliczNiep" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nadliczUczn" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>Czas nieprzepracowany<BR>
						</TD>
						<TD align="right"><ea:datalabel id="płatnePełn" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="płatneNiep" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="płatneUczn" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak1" runat="server"></ea:pagebreak>
			<P><STRONG>Dział 4. SKŁADNIKI KOSZTU PRACY</STRONG> <EM>(brutto w tys. zł, z jednym 
					znakiem po przecinku)</EM></P>
			<P>
				<TABLE id="Table5" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem<BR>
							(pełno- i niepełnozatrudnieni)</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2"><STRONG>Wynagrodzenia i świadczenia ogółem zaliczane w 
								ciężar kosztów jednostki </STRONG><EM>(suma wierszy 02 + 14 do 20, od 22 do 
                            25)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">01</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac01" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn01" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenia osobowe ogółem<BR>
							<EM>(suma wierszy od 03 do 13)</EM></TD>
						<TD align="center"><FONT size="2">02</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac02" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn02" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="3%">&nbsp;</TD>
						<TD>wynagrodzenia zasadnicze</TD>
						<TD align="center"><FONT size="2">03</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac03" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>dodatki za staż pracy</TD>
						<TD align="center"><FONT size="2">04</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac04" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>premie wypłacane periodycznie za osiągnięcia w wykonywaniu podstawowych zadań</TD>
						<TD align="center"><FONT size="2">05</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac05" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>nagrody (bez wypłat z zysku)</TD>
						<TD align="center"><FONT size="2">06</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac06" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenia za pracę w godzinach nadliczbowych <EM>(w odniesieniu do godzin 
								wykazanych w dziale 3 wiersz 3)</EM></TD>
						<TD align="center"><FONT size="2">07</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac07" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenia za czas choroby <EM>(wypłacone wyłącznie ze środków zakładu pracy)</EM></TD>
						<TD align="center"><FONT size="2"><FONT size="2">08</FONT></FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac08" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenie za czas przestojów</TD>
						<TD align="center"><FONT size="2">09</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac09" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>wynagrodzenia za czas nieprzepracowany (np. za urlop wypoczynkowy, okolicznościowy)</TD>
						<TD align="center"><FONT size="2">10</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac10" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>nagrody jubileuszowe, gratyfikacje</TD>
						<TD align="center"><FONT size="2">11</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac11" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>odprawy wypłacone przy przejściu na emeryturę lub rentę</TD>
						<TD align="center"><FONT size="2">12</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac12" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>pozostałe składniki wynagrodzeń osobowych</TD>
						<TD align="center"><FONT size="2">13</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac13" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					</TABLE>
			</P>
			<ea:pagebreak id="Pagebreak2" runat="server"></ea:pagebreak>
			<P><STRONG>Dział 4. SKŁADNIKI KOSZTU PRACY</STRONG> <EM>(brutto w tys. zł, z jednym 
					znakiem po przecinku) (dok.)</EM></P>
			<p>
				<TABLE id="Table4" cellSpacing="1" cellPadding="1" width="100%" border="1">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem<BR>
							(pełno- i niepełnozatrudnieni)</TD>
						<TD align="center" width="25%">Uczniowie</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3"><FONT size="2">0</FONT></TD>
						<TD align="center"><FONT size="2">1</FONT></TD>
						<TD align="center"><FONT size="2">2</FONT></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Dodatkowe wynagrodzenia roczne dla pracowników 
							jednostek sfery budżetowej</TD>
						<TD align="center" width="3%"><FONT size="2">14</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac14" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wynagrodzenia z tytułu umowy zlecenia lub umowy o 
							dzieło <EM>(wynagrodzenia bezosobowe - bez wypłat dla pracowników obcych)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">15</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac15" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Honoraria ogółem <EM>(bez wypłat dla pracowników obcych)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">16</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac16" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki na doskonalenie, kształcenie i 
							przekwalifikowanie kadr</TD>
						<TD align="center" width="3%"><FONT size="2">17</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac17" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki na delegacje służbowe</TD>
						<TD align="center" width="3%"><FONT size="2">18</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac18" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Obligatoryjne składki na ubezpieczenie emerytalne, rentowe i 
							wypadkowe opłacone przez pracodawcę</TD>
						<TD align="center" width="3%"><FONT size="2">19</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac19" runat="server"></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn19" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Dobrowolne składki na ubezpieczenia społeczne</TD>
						<TD align="center" width="3%"><FONT size="2">20</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac20" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">w tym składki na pracownicze systemy emerytalno - rentowe</TD>
						<TD align="center" width="3%"><FONT size="2">21</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac21" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wydatki związane z bezpieczeństwem i higieną pracy</TD>
						<TD align="center" width="3%"><FONT size="2">22</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac22" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Zakładowy fundusz świadczeń socjalnych <EM>(odpis w koszty)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">23</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac23" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Świadczenia o charakterze rzeczowym (m. in. wydatki na samochody służbowe, telefony komórkowe, mieszkania służbowe)</TD>
						<TD align="center" width="3%"><FONT size="2">24</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac24" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Pozostałe wydatki</TD>
						<TD align="center" width="3%"><FONT size="2">25</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac25" runat="server" ></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn25" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2"><STRONG>Wypłaty z tytułu udziału w zysku do podziału lub z 
								nadwyżki bilansowej w spółdzielniach </STRONG><EM>(suma wierszy od 27 do 29)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">26</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac26" runat="server" ></ea:datalabel></TD>
						<TD align="right">
							<ea:datalabel id="uczn26" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Nagrody i premie z tytułu udziału w zysku do podziału 
							lub z nadwyżki bilansowej w spółdzielniach</TD>
						<TD align="center" width="3%"><FONT size="2">27</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac27" runat="server" ></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Wypłaty na rzecz zakładowego funduszu świadczeń 
							socjalnych<EM> (odpis z zysku)</EM></TD>
						<TD align="center" width="3%"><FONT size="2">28</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac28" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
					<TR>
						<TD width="47%" colSpan="2">Inne wypłaty, jakie?<BR>
							. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .</TD>
						<TD align="center" width="3%"><FONT size="2">29</FONT></TD>
						<TD align="right">
							<ea:datalabel id="prac29" runat="server"></ea:datalabel></TD>
						<TD>&nbsp;</TD>
					</TR>
				</TABLE>
			</p>
			<P><eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter></P>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
